<?php

// Query to fetch unique registration numbers and student details (full_name and gender)
$regNumbersQuery = "
    SELECT DISTINCT s.registration_number, s.full_name, s.gender
    FROM students s
    INNER JOIN mathematics m ON s.registration_number = m.registration_number
    WHERE 1=1
";

// Apply class, exam_type, and year filters
if (!empty($filters['class'])) {
    $regNumbersQuery .= " AND m.class = ?";
}
if (!empty($filters['exam_type'])) {
    $regNumbersQuery .= " AND m.exam_type = ?";
}
if (!empty($filters['year'])) {
    $regNumbersQuery .= " AND m.year = ?";
}

$stmt = $con->prepare($regNumbersQuery);

// Bind filter parameters as done previously
$bindParams = [];
if (!empty($filters['class'])) $bindParams[] = $filters['class'];
if (!empty($filters['exam_type'])) $bindParams[] = $filters['exam_type'];
if (!empty($filters['year'])) $bindParams[] = $filters['year'];
if (count($bindParams)) {
    $stmt->bind_param(str_repeat('s', count($bindParams)), ...$bindParams);
}

$stmt->execute();
$regNumbersResult = $stmt->get_result();
$registrationNumbers = [];

// Avoid duplicate registration numbers and store student details
$seenRegistrationNumbers = [];

if ($regNumbersResult->num_rows > 0) {
    while ($row = $regNumbersResult->fetch_assoc()) {
        $regNumber = $row['registration_number'];
        if (!in_array($regNumber, $seenRegistrationNumbers)) {
            $studentData = [
                'registration_number' => $regNumber,
                'full_name' => $row['full_name'],
                'gender' => $row['gender']
            ];
            $registrationNumbers[] = $studentData;
            $seenRegistrationNumbers[] = $regNumber;
        }
    }
}

?>


<!-- Results Table -->
<table class="table table-bordered">
    <thead>
        <tr>
            <th>Registration Number</th>
            <th>Full Name</th>
            <th>Gender</th>
            <th>Mathematics</th>
            <th>English</th>
            <th>Kiswahili</th>
            <th>Physics</th>
            <th>Chemistry</th>
            <th>Biology</th>
            <th>Geography</th>
            <th>History</th>
            <th>Civics</th>
            <th>Total</th>
            <th>Average</th>
            <th>Points</th>
            <th>Division</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($studentResults as $result) : ?>
            <tr>
                <td><?php echo $result['registration_number']; ?></td>
                <td><?php echo $result['full_name']; ?></td>
                <td><?php echo $result['gender']; ?></td>
                <td><?php echo $result['Mathematics']; ?></td>
                <td><?php echo $result['English']; ?></td>
                <td><?php echo $result['Kiswahili']; ?></td>
                <td><?php echo $result['Physics']; ?></td>
                <td><?php echo $result['Chemistry']; ?></td>
                <td><?php echo $result['Biology']; ?></td>
                <td><?php echo $result['Geography']; ?></td>
                <td><?php echo $result['History']; ?></td>
                <td><?php echo $result['Civics']; ?></td>
                <td><?php echo $result['total_score']; ?></td>
                <td><?php echo $result['average_score']; ?></td>
                <td><?php echo $result['points']; ?></td>
                <td><?php echo $result['division']; ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
